   anim_haunted      MatrixP                                                                                MatrixV                                                                                MatrixW                                                                             
   TIMEPARAMS                                FLOAT_PARAMS                            CAMERARIGHT                            EROSION_PARAMS                                STATIC_WORLD_MATRIX                                                                                SAMPLER    +         LIGHTMAP_WORLD_EXTENTS                                COLOUR_XFORM                                                                                PARAMS                            HAUNTPARAMS                                HAUNTPARAMS2                                OCEAN_BLEND_PARAMS                                OCEAN_WORLD_EXTENTS                                anim.vs  #define HAUNT
#ifdef SKINNED
	uniform mat4 pv;
	uniform mat4 fastanim_xform;
	uniform vec4 fastanim_bones[64];
#else
	uniform mat4 MatrixP;
	uniform mat4 MatrixV;
	uniform mat4 MatrixW;
#endif
uniform vec4 TIMEPARAMS;
uniform vec3 FLOAT_PARAMS;

uniform vec3 CAMERARIGHT;

attribute vec4 POS2D_UV;                  // x, y, u + samplerIndex * 2, v

varying vec3 PS_TEXCOORD;
varying vec3 PS_POS;

#if defined( FADE_OUT ) || defined( HAUNT )
	uniform vec4 EROSION_PARAMS;
	uniform mat4 STATIC_WORLD_MATRIX;
	varying vec2 FADE_UV;

#	define EROSION_CAMERAROT			EROSION_PARAMS.w
#endif

#if defined( UI_HOLO )
	varying vec3 PS_TEXCOORD1;
#endif

#if defined( HOLO )
	float filmSkipRand() // This should match the function with the same name in anim.ps
	{
		float steps = 12.;
		float c = fract(sin(ceil(TIMEPARAMS.x * steps) / steps) * 10000.);
		return (c * -.36) * step(.78, c);
	}
#endif

void main()
{
#ifdef SKINNED
	// Oh damn, the samper index is encoded already in the POS2D_UV. Can I encode the array index in there as well?
	// sure we can
    	float boneIndex = floor((POS2D_UV.w + 0.5)/2.0);
    	float samplerIndex = floor(POS2D_UV.z/2.0);
	//int matrix_index = int(POSITION.z + 0.5);
	// This needs thought. There is already a V from UV in it. Can I maybe give up precision? I probably can, they're floats
	// Can I maybe store them as half floats? Does every shader model support that? HMMMMMM
        // Alternatively 4 bits from the U and 4 from the V
	int matrix_index = int(boneIndex);
    	vec3 TEXCOORD0 = vec3(POS2D_UV.z - 2.0*samplerIndex, POS2D_UV.w - 2.0 * boneIndex, samplerIndex);

	float _a = fastanim_bones[matrix_index*2].x;
	float _b = fastanim_bones[matrix_index*2].y;
	float _c = fastanim_bones[matrix_index*2].z;
	float _d = fastanim_bones[matrix_index*2].w;
	float tx = fastanim_bones[matrix_index*2+1].x;
	float ty = fastanim_bones[matrix_index*2+1].y;

	mat4 matWorld = mat4(_a,_b, 0, 0,
						 _c,_d, 0, 0,
						 0, 0, 1, 0,
						 tx, ty, 0, 1); // Column-major!

	mat4 mat = fastanim_xform * matWorld;
	mat4 pvw = pv * mat;

    	vec3 POSITION = vec3(POS2D_UV.xy, 0);
	gl_Position = pvw * vec4(POSITION, 1.0); 

	vec4 world_pos = mat * vec4( POSITION, 1.0 );
//	gl_Position = pv * vec4(POSITION, 1.0);
#else
    	vec3 POSITION = vec3(POS2D_UV.xy, 0);
	// Take the samplerIndex out of the U.
    float samplerIndex = floor(POS2D_UV.z/2.0);
    vec3 TEXCOORD0 = vec3(POS2D_UV.z - 2.0*samplerIndex, POS2D_UV.w, samplerIndex);

	vec3 object_pos = POSITION.xyz;
	vec4 world_pos = MatrixW * vec4( object_pos, 1.0 );

	if(FLOAT_PARAMS.z > 0.0)
	{
		float world_x = MatrixW[3][0];
		float world_z = MatrixW[3][2];
		world_pos.y += sin(world_x + world_z + TIMEPARAMS.x * 3.0) * 0.025;
	}

	mat4 mtxPV = MatrixP * MatrixV;
	gl_Position = mtxPV * world_pos;

#endif

	#if defined( HOLO )
		float filmSkipOffset = sin(filmSkipRand()) * .4;
		gl_Position.y += filmSkipOffset;
	#endif

	PS_TEXCOORD = TEXCOORD0;
	PS_POS = world_pos.xyz;

#if defined( FADE_OUT ) || defined( HAUNT )
	vec4 static_world_pos = STATIC_WORLD_MATRIX * vec4( POSITION.xyz, 1.0 );
    FADE_UV = vec2( static_world_pos.x / 4.0, static_world_pos.y / 8.0 );
	// Do we want a camera space wiggle
	if (EROSION_CAMERAROT != 0.0)
	{
		float camera_x = MatrixV[3][0];
		float camera_z = MatrixV[3][2];
		vec2 cam_pos = vec2(camera_x, camera_z);

		float obj_x = STATIC_WORLD_MATRIX[3][0];
		float obj_z = STATIC_WORLD_MATRIX[3][2];

		vec2 obj_pos = vec2(obj_x, obj_z);
		vec2 delta = obj_pos - cam_pos;

		// add some lateral parallax
		vec2 right_vec = CAMERARIGHT.xz;
		vec2 forward_vec = normalize(vec2(-CAMERARIGHT.z, CAMERARIGHT.x));
		float right = dot(delta, right_vec);
		float forward = dot(delta, forward_vec);
		vec2 totdelta = forward_vec * delta.y + right_vec * -delta.x;
		totdelta.y = -totdelta.y;
		FADE_UV += (totdelta * 0.05);
	}
#endif

#if defined( UI_HOLO )
	PS_TEXCOORD1 = gl_Position.xyw;
#endif
}

    anim.ps  #define HAUNT
#if defined( GL_ES )
precision mediump float;
#endif

uniform mat4 MatrixW;


#if defined( TRIPLE_ATLAS )
    uniform sampler2D SAMPLER[6];
#else
    uniform sampler2D SAMPLER[5];
#endif

#ifndef LIGHTING_H
#define LIGHTING_H

#if !defined( UI_CC )
// Lighting
varying vec3 PS_POS;
#endif

// xy = min, zw = max
uniform vec4 LIGHTMAP_WORLD_EXTENTS;

#define LIGHTMAP_TEXTURE SAMPLER[3]

#ifndef LIGHTMAP_TEXTURE
	#error If you use lighting, you must #define the sampler that the lightmap belongs to
#endif

#if defined( UI_CC )
vec3 CalculateLightingContribution(vec2 pos)
{
	vec2 uv = ( pos - LIGHTMAP_WORLD_EXTENTS.xy ) * LIGHTMAP_WORLD_EXTENTS.zw;
	return texture2D( LIGHTMAP_TEXTURE, uv.xy ).rgb;
}
#else
vec3 CalculateLightingContribution()
{
	vec2 uv = ( PS_POS.xz - LIGHTMAP_WORLD_EXTENTS.xy ) * LIGHTMAP_WORLD_EXTENTS.zw;
	return texture2D( LIGHTMAP_TEXTURE, uv.xy ).rgb;
}

vec3 CalculateLightingContribution( vec3 normal )
{
	return vec3( 1, 1, 1 );
}
#endif

#endif //LIGHTING.h


varying vec3 PS_TEXCOORD;

uniform vec4 TIMEPARAMS;

uniform mat4 COLOUR_XFORM;
uniform vec3 PARAMS;
uniform vec3 FLOAT_PARAMS;
uniform vec4 HAUNTPARAMS;
uniform vec4 HAUNTPARAMS2;
uniform vec4 OCEAN_BLEND_PARAMS;
uniform vec3 CAMERARIGHT;

#define ALPHA_TEST PARAMS.x
#define LIGHT_OVERRIDE PARAMS.y
#define BLOOM_TOGGLE PARAMS.z

#if defined( FADE_OUT ) || defined( HAUNT )
    varying vec2 FADE_UV;
#endif


#if defined( FADE_OUT )
	uniform vec4 EROSION_PARAMS; 

	#if defined( HOLO )
		#define HOLO_SAMPLER			SAMPLER[2]
		#define HOLO_ERODE_INTENSITY	EROSION_PARAMS.x
		#define HOLO_Y_CUTOFF			EROSION_PARAMS.y
		#define NEGATIVE_HOLO_LERP		EROSION_PARAMS.z
	#else
    	#define ERODE_SAMPLER			SAMPLER[2]
		#define EROSION_MIN				EROSION_PARAMS.x
		#define EROSION_RANGE			EROSION_PARAMS.y
		#define EROSION_LERP			EROSION_PARAMS.z
	#endif
#endif

uniform vec4 OCEAN_WORLD_EXTENTS;
#define OCEAN_SAMPLER SAMPLER[4]

#if defined( HOLO )
	float filmSkipRand() // This should match the function with the same name in anim.vs
	{
		float steps = 12.;
		float c = fract(sin(ceil(TIMEPARAMS.x * steps) / steps) * 10000.);
		return (c * -.36) * step(.78, c);
	}
#endif

void main()
{
    vec4 colour;

#if defined( TRIPLE_ATLAS )
    if( PS_TEXCOORD.z < 0.5 )
    {
        colour.rgba = texture2D( SAMPLER[0], PS_TEXCOORD.xy );
    }
    else if( PS_TEXCOORD.z < 1.5 )
    {
        colour.rgba = texture2D( SAMPLER[1], PS_TEXCOORD.xy );
    }
    else
    {
        colour.rgba = texture2D( SAMPLER[5], PS_TEXCOORD.xy );
    }
#else
    if( PS_TEXCOORD.z < 0.5 )
    {
        colour.rgba = texture2D( SAMPLER[0], PS_TEXCOORD.xy );
    }
    else
    {
        colour.rgba = texture2D( SAMPLER[1], PS_TEXCOORD.xy );
    }
#endif

	if (BLOOM_TOGGLE == 1.0)
	{
		gl_FragColor.rgba = vec4(0, 0, 0, colour.a);
		return;
	}

    if(FLOAT_PARAMS.y > 0.0)
    {
    	if(PS_POS.y < FLOAT_PARAMS.x)
    	{
    		discard;
    	}
    }

#if defined ( FADE_OUT )
	if (colour.a >= ALPHA_TEST)
#else
	if (ALPHA_TEST > 0.0)
	{
		if (colour.a >= ALPHA_TEST)
		{
			gl_FragColor = colour.rgba;	
		}
		else
		{
			discard;
		}
	}
    else
#endif
    {
		gl_FragColor.rgba = colour.rgba * COLOUR_XFORM;
		gl_FragColor.rgb = min(gl_FragColor.rgb, gl_FragColor.a);

#if defined( FADE_OUT )
		#if defined( HOLO )
			if (PS_POS.y < (.36 - filmSkipRand()) * .096 + HOLO_Y_CUTOFF)
			{
				discard;
			}

			vec4 orig = gl_FragColor;
			
			vec2 lineUV = vec2(FADE_UV.x * 1., TIMEPARAMS.x * .16);
			float rgbLines = smoothstep(1., .75, texture2D( HOLO_SAMPLER, lineUV ).g);
			float alphaLines = step(HOLO_ERODE_INTENSITY - .01, texture2D( HOLO_SAMPLER, lineUV ).g);

			float filmGrainTime = ceil(TIMEPARAMS.x * 10.) * .1; // Grain runs on 1/10 framerate
			
			float grain = texture2D( HOLO_SAMPLER, FADE_UV.xy * 1. + mod(filmGrainTime * 192.7249753, 9e4)).b;
			float mask = grain * rgbLines;
			gl_FragColor.rgb *= .35 + mask * .65;
			
			// Color grading
			gl_FragColor.rgb = mix(gl_FragColor.rgb, vec3(.85, .68, .57), .05);

			// Fluctuating exposure
			float exposureAdd = texture2D( HOLO_SAMPLER, vec2(mod(TIMEPARAMS.x, 1.), mod(floor(TIMEPARAMS.x) / 256., 256.))).r;
			gl_FragColor.rgb += vec3(exposureAdd * .22);

			float baseAlpha = gl_FragColor.a;
			float alpha = baseAlpha * alphaLines;
			gl_FragColor = mix(orig, vec4(gl_FragColor.r * alpha, gl_FragColor.g * alpha, gl_FragColor.b * alpha, alpha), abs(NEGATIVE_HOLO_LERP));
		#else
			float height = texture2D( ERODE_SAMPLER, FADE_UV.xy).a;
			float erode_val = clamp( ( height - EROSION_MIN ) / EROSION_RANGE, 0.0, 1.0 );
			gl_FragColor.rgba = mix( gl_FragColor.rgba, gl_FragColor.rgba * erode_val, EROSION_LERP );
		#endif
#endif
		
		vec2 world_uv = ( PS_POS.xz - OCEAN_WORLD_EXTENTS.xy ) * OCEAN_WORLD_EXTENTS.zw;
		vec3 world_tint = texture2D( OCEAN_SAMPLER, world_uv ).rgb;
		gl_FragColor.rgb = mix(gl_FragColor.rgb, gl_FragColor.rgb * world_tint.rgb, OCEAN_BLEND_PARAMS.x);

        vec3 light = CalculateLightingContribution();

        gl_FragColor.rgb *= max( light.rgb, vec3( LIGHT_OVERRIDE, LIGHT_OVERRIDE, LIGHT_OVERRIDE ) );
#if defined( HAUNT )
		float xp = FADE_UV.x * 4.0;
		float yp = FADE_UV.y * 8.0;
		float zp = 0.0;

		// Add in a random base to desynchronise identical objects
		xp += HAUNTPARAMS.y;
		zp += HAUNTPARAMS.y;
		yp += HAUNTPARAMS.y;

		const float PI = 3.1415;
		const float TWO_PI = 2.0 * PI;

		xp *= 5.;
		yp *= 5.;
		zp *= 5.;

		float time = HAUNTPARAMS.x;

		float cx = 0.71;
		float cz = 0.71;

		float resx = cx * xp;
		float resz = cz * zp;

		float x = resx+resz;
		float y = yp;

		// scale the effect
		x *= HAUNTPARAMS.w;	
		y *= HAUNTPARAMS.w;

		float strength = HAUNTPARAMS.z;
#if defined(BLOOM)
		// Hmmm, still unsure if it looks better with bloom at a different rate. It adds some obfuscation to the pattern
		time *= -2.0;
#else
		time *= 3.0;
#endif
		float pix = 
        (
              (sin((x + time * 7.0) * HAUNTPARAMS2.x))
            + (cos((y + time * 1.5)  * HAUNTPARAMS2.y))
            + (sin((x + y + 3.0 * time ) / (16.0 + 0.3 * sin(time / 100.0))))
            + (sin(sqrt((x * x + y * y)) * HAUNTPARAMS2.z))
        ) / 4.0;

		// either this:
		pix = 0.5 + 0.5 * sin(pix * PI);
		// or this
		//pix = 0.5 + 0.5 * pix;
		//pix = 0.5 + 0.5 * sin(pix * TWO_PI);

		float orig_a = gl_FragColor.a;
		// pix is the new alpha
		// Take the alpha out of the source pixel
		gl_FragColor.rgb /= orig_a;	

//if (pix > 0.8) pix = 0.8;
//if (pix < 0.95) pix = 0.0;

		float r = gl_FragColor.r;
		float g = gl_FragColor.g;
		float b = gl_FragColor.b;
		float r2 = r * 3.0;
		float g2 = g * 3.0;
		float b2 = b * 3.0;
		vec3 rgb2 = vec3(r2,g2,b2);

		pix = pix * strength;
		gl_FragColor.rgb = (1.0-pix) * gl_FragColor.rgb + pix * rgb2;

		// Multiply in the original alpha
		gl_FragColor.r *= orig_a;
		gl_FragColor.g *= orig_a;
		gl_FragColor.b *= orig_a;

#if defined(BLOOM)
		// This condition isn't needed but if I take it out opengl errs out because sampler accesses are optimized out
//		if ((HAUNTPARAMS.y > 0.5))	// 1 in the bloompass. Could also multiply instead
		{
			float v = pix;
			v *= 0.5;
			v *= orig_a;
			v *= strength;
			// To stop OpenGL on crapping out on unused samplers.....
			gl_FragColor = gl_FragColor * 0.0001 + vec4(v,v,v,orig_a) * 0.9999;
		}
#endif
		// To see the plasma

#endif  
    }
#if defined ( FADE_OUT )
	else
	{
		discard;
	}
#endif
}

                             	      	   
            
         